import refreshTokenHelper from "../../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../../utils/errorHandlingHelper"
import fetchHelper from "../../../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.partnerLocationId) {
    newObjValue = {...newObjValue, 
      C_BPartner_Location_ID: {
        id: body.partnerLocationId,
        tableName: 'C_BPartner_Location'
      }
    }
  }
  if(body.shippingProcessorId) {
    newObjValue = {...newObjValue, 
      M_ShippingProcessor_ID: {
        id: body.shippingProcessorId,
        tableName: 'M_ShippingProcessor'
      }
    }
  }

  if(body.partnerId) {
    const res: any = await fetchHelper(event, 'models/c_bp_shippingacct', 'POST', token, {
      AD_Org_ID: {
        id: body.organizationId,
        tableName: 'AD_Org'
      },
      isActive: body.isActive,
      dutiesShipperAccount: body.dutiesShipperAccount,
      shipperAccount: body.shipperAccount,
      shipperMeter: body.shipperMeter,
      C_BPartner_ID: {
        id: body.partnerId,
        tableName: 'C_BPartner'
      },
      ...newObjValue,
      tableName: 'c_bp_shippingacct'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = {
        status: error.status || error.statusCode || 500,
        message: error.detail || error.message || error.statusMessage
      }
      //if(data.status < 500) {
        //@ts-ignore
        //setCookie(event, 'user', null)
      //}
    }
  }

  return data
})